﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

using Framework.Data;

namespace Framework.Web.UI
{
    [DefaultProperty("MappingName")]
    [ToolboxData("<{0}:MListBox runat=server />")]
    public class MListBox : System.Web.UI.WebControls.ListBox, IMappingControl, IInputControl, ILocalizeControl, IListControl
    {
        [Category("Custom")]
        [DefaultValue("")]
        public string MappingName { get; set; }

        [Category("Custom")]
        [DefaultValue("")]
        public string DefaultValue { get; set; }

        [Category("Custom")]
        [DefaultValue("")]
        public string ListKey { get; set; }

        [Category("Custom")]
        public event ListSrcRequestEventHandler ListSrcRequest;

        [Category("Custom")]
        [DefaultValue("false")]
        public bool IsRequired { get; set; }

        /// <summary>
        /// テキスト値をキーにして、テキストをローカライズするかどうか？
        /// </summary>
        [Category("Custom")]
        [DefaultValue("false")]
        public bool LocalizeByText { get; set; }

        /// <summary>
        /// アイテムがローカライズされているときはtrueになります。
        /// </summary>
        private bool _localized = false;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MListBox()
        {
            this.IsRequired = false;
            this.LocalizeByText = false;
        }

        #region IMappingControl メンバ

        public void RequestMappingData(Framework.Data.MappingData data)
        {
            foreach (ListItem item in base.Items)
            {
                if (item.Selected) data.Add(this.MappingName, item.Value);
            }
        }

        public void SetMappingData(Framework.Data.MappingData data)
        {
            //リストソースを取得し、データバインド
            this.ListSrcDataBind();

            //マッピング
            string mapVal = this.MappingName.IsEmpty() ? null : data[this.MappingName];
            if (mapVal.IsNotEmpty())
            {
                var vals = mapVal.SplitByConma();
                foreach (var val in vals)
                {
                    var item = base.Items.FindByValue(val);
                    if (item != null)
                    {
                        item.Selected = true;
                    }
                }
            }
            else if (this.DefaultValue != null)
            {
                var item = base.Items.FindByValue(this.DefaultValue);
                if (item != null)
                {
                    item.Selected = true;
                }
            }   
        }

        /// <summary>
        /// リストソースを取得し、データバインド
        /// </summary>
        public void ListSrcDataBind()
        {
            if (this.ListKey.IsNotEmpty())
            {
                var listSrc = (ListSrcDataSet)null;
                if (this.ListSrcRequest != null)
                {
                    var e = new ListSrcRequestEventArgs();
                    e.ListKey = this.ListKey;
                    this.ListSrcRequest(this, e);
                    listSrc = e.ListSrc;
                }
                else
                {
                    listSrc = ListMgr.GetListSrc(this.ListKey);
                }

                //テキストのローカライズ
                if (this.LocalizeByText == true)
                {
                    listSrc.ListSrc.Foreach(row =>
                    {
                        row.Text = LTextMgr.GetText(row.Text);
                    });

                    _localized = true;
                }

                base.DataValueField = "Value";
                base.DataTextField = "Text";
                base.DataSource = listSrc;
                base.DataBind();
            }
        }

        #endregion

        #region IInputControl メンバ

        public bool IsValid
        {
            get { return _isValid; }
            set { _isValid = value; }
        }
        private bool _isValid = true;

        public System.Web.UI.Control GetErrorControl()
        {
            return this;
        }

        public bool IsInputed()
        {
            if (this.DefaultValue != null)
            {
                //DefaultValueだけが選択されている場合はfalseをかえす
                bool isInputed = false;
                foreach (ListItem item in base.Items)
                {
                    if ((item.Selected && item.Value != this.DefaultValue)
                        || (!item.Selected && item.Value == this.DefaultValue))
                    {
                        isInputed = true;
                        break;
                    }
                }
                return isInputed;
            }
            else
            {
                return !this.IsBlank();
            }
        }

        public bool IsBlank()
        {
            bool isBlank = true;
            foreach (ListItem item in base.Items)
            {
                if (item.Selected)
                {
                    isBlank = false;
                    break;
                }
            }
            return isBlank;
        }

        public bool ValidateInput(bool dataTypeOnly)
        {
            if (this.IsRequired && this.IsBlank())
            {
                return false;
            }

            return true;
        }

        public void SetValidateResult(bool isSuccess)
        {
            this.IsValid = (this.IsValid && isSuccess);
            base.BackColor = this.IsValid ? UIController.ValidateSuccessColor : UIController.ValidateErrorColor;
        }

        public void ClearInput()
        {
            foreach (ListItem item in base.Items)
            {
                item.Selected = (this.DefaultValue == item.Value);
            }
        }

        public string GetInputValue()
        {
            return base.SelectedValue;
        }

        #endregion


        #region ILocalizeControl メンバ

        public void Localize(System.Globalization.CultureInfo lang)
        {
            if (this.LocalizeByText == true && _localized == false)
            {
                foreach (ListItem item in base.Items)
                {
                    item.Text = LTextMgr.GetText(lang, item.Text);
                }

                _localized = true;
            }
        }

        #endregion
    }
}
